IF NOT EXISTS (SELECT * FROM sys.objects WHERE [name]='CamiAssignation')
CREATE TABLE [dbo].[CamiAssignation](
	[assignationId] [int] IDENTITY(1,1) NOT NULL,
	[userType] [int] NOT NULL,
	[userId] [nvarchar](15)   NOT NULL,
	[syncStatus] [int] NOT NULL,
 CONSTRAINT [PK_CamiAssignation] PRIMARY KEY CLUSTERED 
(
	[assignationId] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE [name]='CamiSyncronisation')
CREATE TABLE [dbo].[CamiSyncronisation](
	[entryId] [int] IDENTITY(1,1) NOT NULL,
	[syncId] [uniqueidentifier] NOT NULL,
	[description] [nvarchar](100)  NOT NULL,
	[systemMessage] [ntext]   NULL,
	[entryDate] [datetime] NOT NULL,
	[syncDate] [datetime] NOT NULL,
	[syncOwnerId] [int] NOT NULL,
 CONSTRAINT [PK_CamiSyncronisation] PRIMARY KEY CLUSTERED 
(
	[entryId] ASC
)WITH (IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

IF NOT EXISTS (
	SELECT * FROM INFORMATION_SCHEMA.ROUTINES
	WHERE [ROUTINE_TYPE]='PROCEDURE' AND [SPECIFIC_NAME]='sp_UpdateRespondentFromRespondentService'
)
BEGIN
	EXEC dbo.sp_executesql @statement = N'
	CREATE PROCEDURE [dbo].[sp_UpdateRespondentFromRespondentService]
				@ProjectId int,
				@UserId int,
				@CollectMode int,
				@ResRespondent varchar(10),
				@ResLanguage int,
				@ResTimeZone int,
				@ResCallBackDate DateTime,
				@ResIntervCall varchar(10),
				@ResCallCount int,
				@ResLastCallDate DateTime,
				@ResCompleted bit,
				@ResPhone varchar(20),
				@ResCodeResult varchar(2),
				@ResLastCompQuest int
AS
	UPDATE Respondent SET
		projectId = @ProjectId,
		collectMode = case when @CollectMode <0 then collectMode else @CollectMode end,
		modifiedBy = @UserId,
		modified = GETUTCDATE(),
		ResLanguage = @ResLanguage,
		ResTimeZone = @ResTimeZone,
		ResCallbackDate = @ResCallBackDate,
		ResIntervCall = @ResIntervCall,
		ResCallCount = @ResCallCount,
		ResLastCallDate = @ResLastCallDate,
		ResCompleted = @ResCompleted,
		Resphone = @ResPhone,
		ResCodeResult = @ResCodeResult,
		ResCall = 1,
		ResLastCompQuest = @ResLastCompQuest
	WHERE
		ResRespondent = @ResRespondent
	
	if @@ROWCOUNT = 0
	BEGIN
		insert into respondent
			(
			ResRespondent,
			projectId,
			collectMode,
			modifiedBy,
			modified,
			ResLanguage,
			ResTimeZone,
			ResCallbackDate,
			ResIntervCall,
			ResTimeSlot,
			ResCallCount,
			ResLastCallDate,
			ResVersion,
			ResPriority,
			ResCompleted,
			ResConfidPhone,
			ResSeed,
			Resphone,
			ResCodeResult,
			ResWaveNo,
			ResBlocked,
			ResCompPredictive,
			ResCall,
			ResMonitored,
			ResLastCompQuest,
			ResPreviousCallDate,
			ResWaveImportNo)
			values
			(
				@ResRespondent,
				@ProjectId,
				@CollectMode,
				@UserId,
				GETUTCDATE(),
				@ResLanguage,
				@ResTimeZone,
				@ResCallBackDate,
				@ResIntervCall,
				0,
				@ResCallCount,
				@ResLastCallDate,
				'''',
				0,
				@ResCompleted,
				'''',
				@ResRespondent,
				@ResPhone,
				@ResCodeResult,
				0,
				0,
				0,
				1,
				0,
				@ResLastCompQuest,
				0,
				0
			)
	END
	'
END
GO
